import { NuqsAdapter } from 'nuqs/adapters/next/app';
import { ReactNode } from "react";
import { ViewTransitions } from "./next-view-transitions";
import { ProviderNextThemes } from "./provider.next-themes";
import { Toaster } from './ui/toaster';

export function Providers({ children }: { children: ReactNode }) {
  return (
    <ProviderNextThemes
      attribute="class"
      defaultTheme="light"
      enableSystem
      disableTransitionOnChange
    >
      <ViewTransitions>
        <NuqsAdapter>
          {children}
        </NuqsAdapter>
      </ViewTransitions>

      <Toaster />
    </ProviderNextThemes>
  )
}
